---
title: Managed Transforms · Cloudflare Rules docs
description: "Managed Transforms allow you to perform common adjustments to HTTP
  request and response headers with the click of a button. The available
  adjustments include:"
lastUpdated: 2025-02-04T15:44:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/transform/managed-transforms/
  md: https://developers.cloudflare.com/rules/transform/managed-transforms/index.md
---

Managed Transforms allow you to perform common adjustments to HTTP request and response headers with the click of a button. The available adjustments include:

* Add bot protection request headers.
* Remove or add headers related to the visitor's IP address.
* Add request header when the WAF detects leaked credentials.
* Add security-related response headers.
* Remove "X-Powered-By" response headers.

For a complete list, refer to [Available Managed Transforms](https://developers.cloudflare.com/rules/transform/managed-transforms/reference/).

When you enable a Managed Transform, Cloudflare internally deploys one or more Transform Rules to handle the common configuration you selected. These generated rules will not count against the [maximum number of Transform Rules](https://developers.cloudflare.com/rules/transform/#availability) available in your Cloudflare plan.

Enabled Managed Transforms will apply to all inbound requests for the zone.

Note

The generated internal Transform Rules will not appear in the Transform Rules list in the Cloudflare dashboard.

## Next steps

For dashboard, API, and Terraform instructions, refer to [Configure Managed Transforms](https://developers.cloudflare.com/rules/transform/managed-transforms/configure/).
