---
title: HTTP DDoS Attack Protection parameters · Cloudflare DDoS Protection docs
description: Configure the HTTP DDoS Attack Protection managed ruleset to change
  the action applied to a given attack or modify the sensitivity level of the
  detection mechanism. You can configure the managed ruleset in the Cloudflare
  dashboard or define overrides via Rulesets API.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/override-parameters/
  md: https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/override-parameters/index.md
---

Configure the HTTP DDoS Attack Protection managed ruleset to change the action applied to a given attack or modify the sensitivity level of the detection mechanism. You can [configure the managed ruleset in the Cloudflare dashboard](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/http-overrides/configure-dashboard/) or [define overrides via Rulesets API](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/http-overrides/configure-api/).

The available parameters are the following:

* [Action](#action)
* [Sensitivity Level](#sensitivity-level)

## Action

API property name: `"action"`.

The action that will be performed for requests that match specific rules of Cloudflare's DDoS mitigation services. The available actions are:

* **Block**

  * API value: `"block"`.
  * Blocks HTTP requests that match the rule expression.

* **Managed Challenge**

  * API value: `"managed_challenge"`.
  * [Managed Challenges](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/#managed-challenge-recommended) help reduce the lifetimes of human time spent solving Captchas across the Internet. Depending on the characteristics of a request, Cloudflare will dynamically choose the appropriate type of challenge based on specific criteria.

* **Interactive Challenge**

  * API value: `"challenge"`.
  * Presents an interactive challenge to the clients making HTTP requests that match a rule expression.

* **Log**

  * API value: `"log"`.
  * Only available on Enterprise plans with the Advanced DDoS Protection subscription. Logs requests that match the expression of a rule detecting HTTP DDoS attacks. Recommended for validating a rule before committing to a more severe action.

* **Connection Close**

  * API value: *N/A* (internal rule action that you cannot use in overrides).
  * The client is instructed to establish a new connection (by disabling `keep-alive`) instead of reusing the existing connection. Existing requests are not affected.

* **Force Connection Close**

  * API value: *N/A* (internal rule action that you cannot use in overrides).

  * Closes ongoing HTTP connections. This action does not block a request, but it forces the client to reconnect. For HTTP/2 and HTTP/3 connections, the connection will be closed even if it breaks other requests running on the same connection.

  * The performed action depends on the HTTP version:

    * HTTP/1: set the [`Connection` header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/Connection#directives) to `close`.
    * HTTP/2: send a [`GOAWAY` frame](https://datatracker.ietf.org/doc/html/rfc7540#section-6.8) to the client.

* **DDoS Dynamic**

  * API value: *N/A* (internal rule action that you cannot use in overrides).
  * Performs a specific action according to a set of internal guidelines defined by Cloudflare. The executed action can be one of the above or an undisclosed mitigation action.

## Sensitivity Level

API property name: `"sensitivity_level"`.

Defines how sensitive a rule is. Affects the thresholds used to determine if an attack should be mitigated. A higher sensitivity level means having a lower threshold, while a lower sensitivity level means having a higher threshold.

The available sensitivity levels are:

| UI value | API value |
| - | - |
| *High* | `"default"` |
| *Medium* | `"medium"` |
| *Low* | `"low"` |
| *Essentially Off* | `"eoff"` |

The default sensitivity level is *High*.

In most cases, when you select the *Essentially Off* sensitivity level the rule will not trigger for any of the selected actions, including *Log*. However, if the attack is extremely large, Cloudflare's protection systems will still trigger the rule's mitigation action to protect Cloudflare's network.

*Essentially Off* means that we have set an exceptionally low sensitivity level so in most cases traffic will not be mitigated for you. However, attack traffic will be mitigated at exceptional levels to ensure the safety and stability of the Cloudflare network.

**Log** means that requests will not be mitigated but only logged and shown on the dashboard. However, attack traffic will be mitigated at exceptional levels to ensure the safety and stability of the Cloudflare network.
